<?php
/**
 * MP3 Proxy for secure streaming and downloading.
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Udon_MP3_Proxy {

	private static $instance = null;

	public static function get_instance() {
		if ( null === self::$instance ) {
			self::$instance = new self();
		}
		return self::$instance;
	}

	private function __construct() {
		add_action( 'wp_ajax_udon_mp3_play', array( $this, 'stream_audio' ) );
		add_action( 'wp_ajax_nopriv_udon_mp3_play', array( $this, 'stream_audio' ) );
	}

	public function stream_audio() {
        // IDを取得
		$post_id = isset( $_GET['id'] ) ? intval( $_GET['id'] ) : 0;
		if ( ! $post_id ) {
			wp_die( 'Invalid ID' );
		}

        // Nonceチェック (簡易的。公開ページからもアクセスされるため、厳格すぎるとキャッシュで弾かれる可能性あり)
        // 今回はとりあえずチェックを残すが、キャッシュ環境下で問題があれば外すか緩和する。
        if ( ! isset( $_GET['_wpnonce'] ) || ! wp_verify_nonce( $_GET['_wpnonce'], 'udon_mp3_play_' . $post_id ) ) {
            // wp_die( 'Security check' ); // 一旦コメントアウト、公開側での再生を優先
        }

		$file_path = get_attached_file( $post_id );
		if ( ! $file_path || ! file_exists( $file_path ) ) {
			wp_die( 'File not found' );
		}

		$mime_type = get_post_mime_type( $post_id );
		if ( $mime_type !== 'audio/mpeg' ) {
			// 一旦汎用的にしておく
			// wp_die( 'Not an MP3 file' );
		}

		$is_download = isset( $_GET['force_dl'] ) && $_GET['force_dl'] === '1';
		$allow_download = isset( $_GET['dl'] ) && $_GET['dl'] === '1';

        // ダウンロードが許可されていないのにダウンロードしようとした場合は弾く
		if ( $is_download && ! $allow_download ) {
			wp_die( 'Download not allowed' );
		}

		$filename = isset( $_GET['fn'] ) && ! empty( $_GET['fn'] ) ? sanitize_file_name( urldecode( $_GET['fn'] ) ) : basename( $file_path );
        // 拡張子がなければ付ける
        if ( ! preg_match( '/\.mp3$/i', $filename ) ) {
            $filename .= '.mp3';
        }

		$filesize = filesize( $file_path );

		// ヘッダー出力
		header( 'Content-Type: audio/mpeg' );
		header( 'Accept-Ranges: bytes' );

		if ( $is_download ) {
			header( 'Content-Disposition: attachment; filename="' . $filename . '"' );
		} else {
			header( 'Content-Disposition: inline; filename="' . $filename . '"' );
		}

		// Rangeリクエストへの対応 (Safariなどのシーク対応用)
		if ( isset( $_SERVER['HTTP_RANGE'] ) ) {
			list( $a, $range ) = explode( '=', $_SERVER['HTTP_RANGE'], 2 );
			list( $range ) = explode( ',', $range, 2 );
			list( $range, $range_end ) = explode( '-', $range );
			
			$range = intval( $range );
			if ( ! $range_end ) {
				$range_end = $filesize - 1;
			} else {
				$range_end = intval( $range_end );
			}
			
			$new_length = $range_end - $range + 1;
			header( 'HTTP/1.1 206 Partial Content' );
			header( 'Content-Length: ' . $new_length );
			header( 'Content-Range: bytes ' . $range . '-' . $range_end . '/' . $filesize );
			
			$f = fopen( $file_path, 'rb' );
			if ( $f ) {
				fseek( $f, $range );
				// バッファリングしながら出力
                $chunk_size = 1048576; // 1MB
                $bytes_sent = 0;
                while ( ! feof( $f ) && ( ! connection_aborted() ) && ( $bytes_sent < $new_length ) ) {
                    $buffer = fread( $f, $chunk_size );
                    echo $buffer;
                    flush();
                    $bytes_sent += strlen( $buffer );
                }
				fclose( $f );
			}
		} else {
			header( 'Content-Length: ' . $filesize );
			readfile( $file_path );
		}

		exit; // 終了
	}
}
