<?php
/**
 * Admin Panel & Settings.
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Udon_MP3_Admin {

	/**
	 * Instance of this class.
	 */
	private static $instance = null;

	public static function get_instance() {
		if ( null === self::$instance ) {
			self::$instance = new self();
		}
		return self::$instance;
	}

	private function __construct() {
		add_action( 'admin_menu', array( $this, 'add_plugin_page' ) );
		add_action( 'admin_init', array( $this, 'page_init' ) );
        add_action( 'admin_enqueue_scripts', array( $this, 'enqueue_admin_scripts' ) );
        
        // メディアボタン追加 (クラシックエディタ用)
        add_action( 'media_buttons', array( $this, 'add_media_button' ), 15 );
        add_action( 'admin_footer', array( $this, 'add_inline_media_script' ) );
	}

    /**
     * Enqueue admin scripts for Gutenberg/Media Modal
     */
    public function enqueue_admin_scripts( $hook ) {
        // 全体の設定画面用
        if ( 'settings_page_udon-mp3-player' === $hook ) {
            // style etc.
        }

        // 投稿編集画面用
        if ( in_array( $hook, array( 'post.php', 'post-new.php' ), true ) ) {
            wp_enqueue_media();
            wp_enqueue_script( 'udon-mp3-admin-js', UDON_MP3_PLAYER_PLUGIN_URL . 'assets/js/udon-mp3-admin.js', array( 'jquery', 'media-views' ), UDON_MP3_PLAYER_VERSION, true );
            
            // 翻訳テキスト渡し
            wp_localize_script( 'udon-mp3-admin-js', 'udonMp3AdminL10n', array(
                'title'       => 'うどんMP3プレーヤーを挿入',
                'button_text' => 'ショートコードを挿入',
            ) );
        }
    }

    /**
     * クラシックエディタ用の「メディアを追加」隣のボタン
     */
    public function add_media_button() {
        echo '<a href="#" id="insert-udon-mp3-btn" class="button"><span class="dashicons dashicons-controls-play" style="margin-top:4px;"></span> うどんMP3追加</a>';
    }

    /**
     * クラシックエディタ用のインラインJS (TinyMCEへ挿入)
     */
    public function add_inline_media_script() {
        global $pagenow;
        if ( in_array( $pagenow, array( 'post.php', 'post-new.php' ), true ) ) {
            // actual JS is in assets/js/udon-mp3-admin.js
        }
    }

	public function add_plugin_page() {
		add_options_page(
			'うどんMP3設定', 
			'うどんMP3', 
			'manage_options', 
			'udon-mp3-player', 
			array( $this, 'create_admin_page' )
		);
	}

	public function create_admin_page() {
		?>
		<div class="wrap">
			<h1>うどんMP3プレーヤー 設定</h1>
			<form method="post" action="options.php">
			<?php
				settings_fields( 'udon_mp3_option_group' );
				do_settings_sections( 'udon-mp3-setting-admin' );
				submit_button();
			?>
			</form>
		</div>
		<?php
	}

	public function page_init() {
		register_setting(
			'udon_mp3_option_group',
			'udon_mp3_color_theme',
			array( 'sanitize_callback' => 'sanitize_text_field' )
		);
		
		register_setting(
			'udon_mp3_option_group',
			'udon_mp3_player_name',
			array( 'sanitize_callback' => 'sanitize_text_field' )
		);

		add_settings_section(
			'udon_mp3_setting_section_id',
			'基本設定',
			array( $this, 'print_section_info' ),
			'udon-mp3-setting-admin'
		);

		add_settings_field(
			'udon_mp3_player_name',
			'プレーヤー名称',
			array( $this, 'player_name_callback' ),
			'udon-mp3-setting-admin',
			'udon_mp3_setting_section_id'
		);

		add_settings_field(
			'udon_mp3_color_theme',
			'カラーセット',
			array( $this, 'color_theme_callback' ),
			'udon-mp3-setting-admin',
			'udon_mp3_setting_section_id'
		);
	}

	public function print_section_info() {
		print 'ショートコードのデフォルト設定を選択してください。';
	}

	public function player_name_callback() {
		$val = get_option( 'udon_mp3_player_name', 'うどんMP3プレーヤー' );
		printf(
			'<input type="text" id="udon_mp3_player_name" name="udon_mp3_player_name" value="%s" />',
			esc_attr( $val )
		);
	}

	public function color_theme_callback() {
		$val = get_option( 'udon_mp3_color_theme', 'dark' );
		
		$themes = array(
			'dark'     => 'ダーク',
			'light'    => 'ライト',
			'colorful' => 'カラフル',
			'metal'    => 'メタル',
			'simple'   => 'シンプル',
		);
		
		echo '<select id="udon_mp3_color_theme" name="udon_mp3_color_theme">';
		foreach ( $themes as $key => $label ) {
			printf(
				'<option value="%s" %s>%s</option>',
				esc_attr( $key ),
				selected( $val, $key, false ),
				esc_html( $label )
			);
		}
		echo '</select>';
	}
}
