(function (blocks, element, blockEditor, components, serverSideRender) {
    var el = element.createElement;
    var useBlockProps = blockEditor.useBlockProps;
    var InspectorControls = blockEditor.InspectorControls;
    var PanelBody = components.PanelBody;
    var ToggleControl = components.ToggleControl;
    var TextControl = components.TextControl;
    var MediaUpload = blockEditor.MediaUpload;
    var Button = components.Button;
    var ServerSideRender = serverSideRender;

    blocks.registerBlockType('udon-mp3/player', {
        title: 'うどんMP3',
        icon: 'controls-play',
        category: 'media',
        attributes: {
            audioId: { type: 'number', default: 0 },
            download: { type: 'string', default: 'no' },
            fileName: { type: 'string', default: '' },
            titleStr: { type: 'string', default: '' }
        },

        edit: function (props) {
            var attributes = props.attributes;
            var setAttributes = props.setAttributes;
            var blockProps = useBlockProps();

            var onSelectMedia = function (media) {
                setAttributes({
                    audioId: media.id,
                    titleStr: media.title
                });
            };

            var inspector = el(
                InspectorControls,
                {},
                el(
                    PanelBody,
                    { title: '設定', initialOpen: true },
                    el(ToggleControl, {
                        label: 'ダウンロードを許可する',
                        checked: attributes.download === 'yes',
                        onChange: function (val) {
                            setAttributes({ download: val ? 'yes' : 'no' });
                        }
                    }),
                    attributes.download === 'yes' ? el(TextControl, {
                        label: 'ダウンロードファイル名 (省略可)',
                        value: attributes.fileName,
                        onChange: function (val) {
                            setAttributes({ fileName: val });
                        }
                    }) : null,
                    el(TextControl, {
                        label: '曲のタイトル (上書き用)',
                        value: attributes.titleStr,
                        onChange: function (val) {
                            setAttributes({ titleStr: val });
                        }
                    }),
                    el(Button, {
                        isSecondary: true,
                        style: { marginTop: '15px' },
                        onClick: function () {
                            setAttributes({ audioId: 0, titleStr: '', fileName: '', download: 'no' });
                        }
                    }, '音源をクリアして選び直す')
                )
            );

            // if no audio selected
            if (!attributes.audioId) {
                var btn = el(
                    MediaUpload,
                    {
                        onSelect: onSelectMedia,
                        allowedTypes: ['audio'],
                        render: function (obj) {
                            return el(
                                Button,
                                {
                                    className: 'button button-large',
                                    onClick: obj.open
                                },
                                '🎧 MP3ファイルを選択'
                            );
                        }
                    }
                );

                return el(
                    'div',
                    blockProps,
                    inspector,
                    el(
                        'div',
                        {
                            style: {
                                padding: '20px',
                                border: '2px dashed #ccc',
                                textAlign: 'center',
                                backgroundColor: '#f9f9f9'
                            }
                        },
                        el('h4', { style: { marginTop: 0 } }, 'うどんMP3プレーヤー'),
                        el('div', {}, btn)
                    )
                );
            }

            // Preview state using server-side render
            return el(
                'div',
                blockProps,
                inspector,
                el(ServerSideRender, {
                    block: 'udon-mp3/player',
                    attributes: attributes
                })
            );
        },

        save: function () {
            // Server side rendered block
            return null;
        }
    });
}(
    window.wp.blocks,
    window.wp.element,
    window.wp.blockEditor,
    window.wp.components,
    window.wp.serverSideRender
));
