jQuery(document).ready(function($) {
    var mediaUploader;

    $('#insert-udon-mp3-btn').on('click', function(e) {
        e.preventDefault();

        // 既に開かれていたら再利用
        if (mediaUploader) {
            mediaUploader.open();
            return;
        }

        // メディアフレームの作成
        mediaUploader = wp.media.frames.file_frame = wp.media({
            title: typeof udonMp3AdminL10n !== 'undefined' ? udonMp3AdminL10n.title : 'うどんMP3プレーヤーを挿入',
            button: {
                text: typeof udonMp3AdminL10n !== 'undefined' ? udonMp3AdminL10n.button_text : 'ショートコードを挿入'
            },
            multiple: false,
            library: {
                type: 'audio'
            }
        });

        // 選択時のイベントハンドラ
        mediaUploader.on('select', function() {
            var attachment = mediaUploader.state().get('selection').first().toJSON();
            
            // 音声ファイルのみ処理（原則 mp3 だが）
            if (attachment.type === 'audio') {
                var fileId = attachment.id;
                var fileName = attachment.filename;
                var title = attachment.title;

                // ダウンロード許可のプロンプト
                var isDownload = confirm('音源のダウンロードを許可しますか？\n[OK]で許可, [キャンセル]で不可');
                var dlParam = isDownload ? 'yes' : 'no';
                
                var customFileName = '';
                if (isDownload) {
                    customFileName = prompt('ダウンロード時のファイル名を指定してください(省略可):\n例: custom_song.mp3', fileName) || '';
                }

                // ショートコードの生成
                var shortcode = '[udon_mp3 id="' + fileId + '" download="' + dlParam + '"';
                if (customFileName) {
                    shortcode += ' filename="' + customFileName + '"';
                }
                
                // 元のタイトルを含めておくと表示に便利
                if (title) {
                    shortcode += ' title="' + title + '"';
                }
                shortcode += ']';

                // エディタへ挿入（TinyMCEがアクティブならそちらへ、そうでなければテキストエリアへ）
                if (typeof tinymce !== 'undefined' && tinymce.activeEditor && !tinymce.activeEditor.isHidden()) {
                    tinymce.activeEditor.execCommand('mceInsertContent', false, shortcode);
                } else if (typeof QTags !== 'undefined') {
                    QTags.insertContent(shortcode);
                } else {
                    // Gutenberg等の場合の代替表示など(簡易)
                    prompt('以下のショートコードをコピーして記事に貼り付けてください：', shortcode);
                }
            } else {
                alert('オーディオファイルを選択してください。');
            }
        });

        // 開く
        mediaUploader.open();
    });
});
